/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.client.ClientDelayedCache;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.slf4j.Logger;

public class AccessoryRendererErrorCache {
    private static final ClientDelayedCache<Key> ERROR_CACHE = new ClientDelayedCache(4000);
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void logIfTimeAllotted(class_1297 entity, class_1799 stack, AccessoryRenderer renderer, Throwable e) {
        Key key = new Key(entity.method_5667(), class_1799.method_57355((class_1799)stack), AccessoriesRendererRegistry.getRendererId(renderer));
        if (ERROR_CACHE.hasAllottedTime(key, 10.0f)) {
            LOGGER.error("[AccessoryRendererError] Unable to use the given Renderer [{}] to render the given item [{}] for [{}] due to the given error: ", new Object[]{key.rendererId(), stack, entity, e});
        }
    }

    public record Key(UUID entityUUID, int itemStackHash, class_2960 rendererId) {
    }
}

